const mysql = require('mysql');

if (process.env.NODE_ENV !== 'production') {
    require('dotenv').config();
}

const db = mysql.createConnection({
    host: process.env.HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_DATABASE,
    // port: process.env.PORT || 3306,
    // ssl: process.env.NODE_ENV === 'production' ? false : { rejectUnauthorized: true }
});

db.connect((err) => {
    if (err) {
        console.error('Error connecting to the database:', err);
        process.exit(1);  
    } else {
        console.log('MySQL connected successfully!');
    }
});

module.exports = db;
