const db = require('../config/database');
const nodemailer = require("nodemailer");


const transporter = nodemailer.createTransport({
    host: "smtp.gmail.com",
    port: 587,
    secureConnection: true,
    auth: {
      user: "business@ftv.ind.in",
      pass: "bohjspazpvctxhmu",
    },
    tls: {
      rejectUnauthorized: false,
    },
});




module.exports = {

    user: (data, callBack) => {
        db.query(`INSERT INTO auth(name,email,password,status)VALUES(?,?,?,?)`,
            [data.name, data.email, data.password, data.status],
            (error, results, fields) => {
                if(error){
                    return callBack(error);
                }
                return callBack(null, results);
            }
        );
    },

    getUserByUserEmail: (email, callBack) => {
        db.query(`SELECT * FROM auth where email = ?`,
            [email],
            (error, results, fields) => {
                if(error){
                    callBack(error);
                }
                return callBack(null, results[0]);
            }
        );

    },

    create: (data, callBack) => {
        db.query(`SELECT * FROM enquires WHERE contact = ?`, [data.contact],
        (error, results, fields) => {
            if (error) {
                console.error("Database Query Error:", error);
                return callBack({message: "Database Query Error"});
            }

            if (results.length > 0) {
                return callBack({
                    message: "User with this contact number already exists. Please use a different number."
                });
            }

            db.query(
                `INSERT INTO enquires(unique_code,fullname, email, contact, state, city, investment, message, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)`,
                [
                    data.uniqueID,
                    data.fullname,
                    data.email,
                    data.contact,
                    data.state,
                    data.city,
                    data.investment,
                    data.message,
                    data.created_at,
                ],
                (error, results, fields) => {
                    if (error) {
                        console.error("Database Insertion error:", error);
                        if(error.code === "ER_DUP_ENTRY") {
                            return callBack ({
                                message: "Duplicate entry. User with this unique code already exists.",
                            });
                        } else {
                            return callBack({
                                message : "Error occurred while inserting user."
                            });
                        }
                    }
                    return callBack(null, results);
                }
            );


        });

    },


    checkFetchMetaData: (metasource, callBack) => {
        db.query(`SELECT * FROM meta_content WHERE meta_source_name = ?`,
            [metasource],
            (error, results, fields) => {
                if(error) {
                    return callBack(error);
                }
                return callBack(null, results);
            }
        );
    },

    checkIfEmailExists: (subscribe_email , callBack) => {
        db.query(`SELECT * FROM newsletter WHERE email = ?`, [subscribe_email],
            (error, results, fields) => {
                if (error) {
                    callBack(error);
                }
                return callBack(null, results);
            }
        );

    },

    addNewSubscriber: (data, callBack) => {
        db.query (`INSERT INTO newsletter (email,subscribe_status,created_at)values(?,?,?)`,
            [data.email, data.subscribe_status, data.created_at],
            (error, results, fields) => {
                if (error){
                    callBack(error);
                }
                return callBack(null, results);
            }
        );
    },

    sendWelcomeEmail: (email, callBack) => {
        const mailOptions = {
          from: "noreply@ftvrealestate.in",
          to: email,
          subject: "Welcome to Our Newsletter!",
          text: "Thank you for subscribing to our newsletter. We are excited to have you on board!",
        };

        transporter.sendMail(mailOptions, (error, info) => {
            if (error) {
                console.error("Error sending email:", error);
                callBack(error, null);
            } else {
                console.log("Email sent:", info.response);
                callBack(null, true);
            }
        });
        
    }





}